/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

/*  This is designed to serve as both an example on how to make a plugin and to give users the basic framework of a plugin.
    The plugin is simple: it creates an object creation hook and attaches the script "Plugin_Example_Script" to all objects.
	The script prints out a message whenever an object is created or destroyed.
	There are also examples of the new format for bhs.dll hooks.
*/

#include "scripts.h"
#include <stdarg.h>
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "engine.h"
#include "gmmain.h"
#include "plugin.h"

ExampleSettingsStruct *ExampleSettings = 0;

void ExampleSettingsStruct::Load() {
	SettingsLoader::Load();

	LoadBool(Var,"Variable");
	printf("ExampleSettings variable: %d\n",Var);

	LoadList(List,"List");
	printf("ExampleSettings List[0]: %s\n",List[0].c_str());
}


int ObjectHookID = 0;
ObjectCreateHookStruct *ObjectHookStruct = 0;


void ObjectHookCall(void *data,GameObject *obj) {
	Attach_Script_Once(obj,"Plugin_Example_Script","");
}

//This is called in Set_Script_Commands the same way that SSGM_Secondary_Load is called in SSGM.
//Keeps the loading code specific to the plugin out of dllmain.cpp.
//This is not required, you can do your loading code anyway you want.
void Plugin_Load() {
	ExampleSettings = new ExampleSettingsStruct("Example.ini");

	ObjectHookStruct = new ObjectCreateHookStruct;
	ObjectHookStruct->hook = ObjectHookCall;
	ObjectHookStruct->data = 0;
	ObjectHookID = AddObjectCreateHook(ObjectHookStruct);
}

//Called in SSGM_Plugin_Unload. Keeps the unloading code specific to the plugin out of dllmain.cpp.
//This is not required, you can do your unloading code anyway you want.
void Plugin_Unload() {
	delete ExampleSettings;
	delete ObjectHookStruct;
}

//An example script that prints a message whenever an object is created or destroyed.
//Remove this when making a real plugin.
void Plugin_Example_Script::Created(GameObject *obj) {
	printf("Plugin_Example_Script::Created %s\n",Commands->Get_Preset_Name(obj));
}

void Plugin_Example_Script::Destroyed(GameObject *obj) {
	printf("Plugin_Example_Script::Destroyed %s\n",Commands->Get_Preset_Name(obj));
}
ScriptRegistrant<Plugin_Example_Script> Plugin_Example_Script_Registrant("Plugin_Example_Script","");



//Example of a chat command using the ChatCommandClass.
//Remove this when making a real plugin.
class TestChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		/* Text is a tokenized version of the command paramter.
		   Text[1] would get the first word after the command.
		   Text[0] would get everything after the command.
		   Text(3) would get word 3 and everything after it.
		   Text(2,4) would get words 2 through 4.
	   */
		Console_Input(StrFormat("ppage %d loltest parameters: \"%s\"",ID,Text(1).c_str()).c_str());
	}
};
ChatCommandRegistrant<TestChatCommand> TestChatCommandReg(
"!test", //Name of the command. Seperate multiple names with ;.
CHATTYPE_ALL, //What type of chat the command can be triggered in. CHATTYPE_ALL, CHATTYPE_TEAM, and CHATTYPE_PUBLIC.
1, //How many parameters the command needs. !Donate, for example, would need two. One would be the name of the player and the other would be the amount.
GAMEMODE_ALL //The game mode that this command can be used in.
);



extern "C" {

//The names of the following hooks must not be changed. They can be removed if you're not using them though.
DLLEXPORT void SSGM_Chat_Hook(int ID, int Type, const wchar_t *Msg) {
	printf("SSGM_Chat_Hook called %d %d %S\n",ID,Type,Msg);
}

DLLEXPORT void SSGM_Host_Hook(int ID, int Type, const char *Msg) {
	printf("SSGM_Host_Hook called %d %d %s\n",ID,Type,Msg);
}

DLLEXPORT void SSGM_Player_Join_Hook(int ID, const char *Nick) {
	printf("SSGM_Player_Join_Hook called %d %s\n",ID,Nick);
}

DLLEXPORT void SSGM_Player_Leave_Hook(int ID) {
	printf("SSGM_Player_Leave_Hook called %d\n",ID);
}

DLLEXPORT void SSGM_Level_Loaded_Hook() {
	ExampleSettings->Load();
	printf("SSGM_Level_Loaded_Hook called\n");
}

DLLEXPORT void SSGM_GameOver_Hook() {
	printf("SSGM_GameOver_Hook called\n");
}

DLLEXPORT void SSGM_Console_Output_Hook(const char *Output) {
	printf("SSGM_Console_Output_Hook called %s\n",Output);
}

//Hook into SSGM's DDE channel.
//Return false to stop it from being passed to the console.
DLLEXPORT bool SSGM_DDE_Hook(const char *DDE) {
	printf("SSGM_DDE_Hook called %s\n",DDE);
	TokenClass Text(DDE);
	if (Text[1] == "test") {
		printf("\"%s\" command called with parameters: \"%s\"\n",Text[1].c_str(),Text(2).c_str());
		return false;
	}
	return true;
}

}


